<?

//----------------------------------------------------------

// Namo WebEditor dbWizard Script.
// Copyright 2004 Sejoong Namo Interacive Inc. All Rights Reserved.
//
// include 'wed_php_ODBC.inc'

//----------------------------------------------------------

define("WED_NULL_STR", "");
define("WED_NAN", "-32768");
define("WED_NULL_INT", "-1");
define("WED_CUR_DATE", "");
define("WED_MAX_INT", "32767");
define("WED_MAX_PAGE", "10");

//----------------------------------------------------------

function wed_input_int($name, $value, $maxlength, $size)
{
    echo("<input type=\"text\"");
    if ($name != WED_NULL_STR) {
        echo(" name=\""); echo($name); echo("\"");
    }
    if ($value != WED_NAN) {
        echo(" value=\""); echo($value); echo("\"");
    }
    if ($maxlength != WED_NULL_INT) {
        echo(" maxlength=\""); echo($maxlength); echo("\"");
    }
    if ($size != WED_NULL_INT) {
        echo(" size=\""); echo($size); echo("\"");
    }
    echo(" onChange=\"wed_check_int(this)\">");
}

//----------------------------------------------------------

function wed_input_str($name, $value, $maxlength, $size)
{
    echo("<input type=\"text\"");
    if ($name != WED_NULL_STR) {
        echo(" name=\""); echo($name); echo("\"");
    }
    if ($value != WED_NULL_STR) {
        echo(" value=\""); echo($value); echo("\"");
    }
    if ($maxlength != WED_NULL_INT) {
        echo(" maxlength=\""); echo($maxlength); echo("\"");
    }
    if ($size != WED_NULL_INT) {
        echo(" size=\""); echo($size); echo("\"");
    }
    echo(">");
}

//----------------------------------------------------------

function wed_input_text($name, $value, $rows, $cols)
{
    echo("<textarea");
    if ($name != WED_NULL_STR) {
        echo(" name=\""); echo($name); echo("\"");
    }
    if ($rows != WED_NULL_INT) {
        echo(" rows=\""); echo($rows); echo("\"");
    }
    if ($cols != WED_NULL_INT) {
        echo(" cols=\""); echo($cols); echo("\"");
    }
    echo(">");
    if ($value != WED_NULL_STR) {
        echo($value);
    }
    echo("</textarea>");
}

//----------------------------------------------------------

function wed_input_hidden($name, $value)
{
    echo("<input type=\"hidden\"");
    if ($name != WED_NULL_STR) {
        echo(" name=\""); echo($name); echo("\"");
    }
    if ($value != WED_NULL_STR) {
        echo(" value=\""); echo($value); echo("\"");
    }
    echo(">");

//    $w_value = str_replace("\n", "<br>", $value);
//    echo($w_value);
}

//----------------------------------------------------------

function wed_input_combo($servername, $userid, $passwd, $sqlstr, $name, $valuefield, $stringfield, $selectvalue)
{
    $connect = odbc_connect($servername, $userid, $passwd);
    $cursor  = odbc_exec($connect, $sqlstr);

    echo("<select name=\""); echo($name); echo("\">\n");

    for ($rows = 0; odbc_fetch_into($cursor, /*$rows,*/ &$row); $rows++) {
        $value = $row[$valuefield];
        $str   = $row[$stringfield];

        echo("<option ");
        if ($value == $selectvalue) {
            echo("selected ");
        }
        echo("value=\""); echo($value); echo("\">");
        echo($str); echo("\n");
    }

    echo("</select>");

    odbc_close($connect);
}

//----------------------------------------------------------

function wed_input_radio($servername, $userid, $passwd, $sqlstr, $name, $valuefield, $stringfield, $selectvalue)
{

    $connect = odbc_connect($servername, $userid, $passwd);
    $cursor  = odbc_exec($connect, $sqlstr);

    for ($rows = 0; odbc_fetch_into($cursor, /*$rows,*/ &$row); $rows++) {
        $value = $row[$valuefield];
        $str   = $row[$stringfield];

        if ($rows == 0) {
            echo("<p>");
        } else {
            echo("<br>");
        }
        echo("<input type=\"radio\" ");
        echo("name=\""); echo($name); echo("\" ");
        echo("value=\""); echo($value); echo("\"");
        if ($value == $selectvalue) {
            echo(" checked");
        }
        echo(">"); echo($str); echo("\n");
    }

    odbc_close($connect);
}

//----------------------------------------------------------

function write_option($startval, $endval, $selectval)
{
    for ($i = $startval; $i <= $endval; $i++) {
		if ($i < 10) {
	    	echo("<option value=\""); echo($i); echo("\"");
            if ($i == $selectval) {
	        	echo(" selected");
            }
	    	echo(">0"); echo($i); echo("\n");
		}
		else {
	    	echo("<option value=\""); echo($i); echo("\"");
            if ($i == $selectval) {
	        	echo(" selected");
            }
		    echo(">"); echo($i); echo("\n");
		}
    }
}

//----------------------------------------------------------

function wed_input_date($name, $value, $intfmt)
{
    // locidx(0, x) : intfmt yy, mm, dd, hh, mi ġ
    // locidx(1, x) : yy = 1, mm = 2, ... mi = 5
    // locidx(2, x) : intfmt yy, mm  Ÿ 

    if ($value == WED_CUR_DATE) {
        $value = date("Y-m-d H:i");
    }

    if (($timestamp = strtotime($value)) == -1) {
    	$datetime = getdate();
    } else {
    	$datetime = getdate($timestamp);
    }

    $yy = $datetime['year'];
    $mm = $datetime['mon'];
    $dd = $datetime['mday'];
    $hh = $datetime['hours'];
    $mi = $datetime['minutes'];

    if ($intfmt == WED_NULL_STR) {
        $intfmt = "mm/dd/yy hh:mi";
        //$intfmt = "yymmdd hhmi";
        //$intfmt = "hhmi yymmdd";
    }

    $locidx[0][0] = strpos($intfmt, "yy");
    $locidx[0][1] = strpos($intfmt, "mm");
    $locidx[0][2] = strpos($intfmt, "dd");
    $locidx[0][3] = strpos($intfmt, "hh");
    $locidx[0][4] = strpos($intfmt, "mi");

    for ($i = 0; $i < 5; $i++) {
        if (!is_int($locidx[0][$i])) {
            $locidx[0][$i] = WED_MAX_INT;
        }
        $locidx[1][$i] = $i + 1;
        $locidx[2][$i] = 0;
    }

    for ($i = 0; $i < 5; $i++) {
        for ($j = ($i + 1); $j < 5; $j++) {
            if ($locidx[0][$i] > $locidx[0][$j]) {
                $tmp = $locidx[0][$i];
                $locidx[0][$i] = $locidx[0][$j];
                $locidx[0][$j] = $tmp;

                $tmp = $locidx[1][$i];
                $locidx[1][$i] = $locidx[1][$j];
                $locidx[1][$j] = $tmp;
            }
        }
    }

    for ($i = 0; $i < 5; $i++) {
        for ($j = 0; $j < 5; $j++) {
            if ($locidx[1][$j] == ($i + 1)) {
                $locidx[2][$i] = $j + 1;
            }
        }
    }

    for ($i = 0; $i < 5; $i++) {
        if ($locidx[0][$locidx[2][$i] - 1] == WED_MAX_INT) {
            $locidx[2][$i] = WED_NULL_INT;
        }
    }

    $prevpos = 0;
    for ($i = 0; $i < 5; $i++) {
        if ($prevpos < $locidx[0][$i]) {
            $fmtstr[$i] = substr($intfmt, $prevpos, $locidx[0][$i] - $prevpos);
            $prevpos = $locidx[0][$i];
        }
        $prevpos = $prevpos + 2; // yy, mm, dd, hh, mi
    }

    if ($prevpos <= strlen($intfmt)) {
        $fmtstr[5] = substr($intfmt, $prevpos, strlen($intfmt) - $prevpos + 1);
    }

    // ݵ hidden  . (javascript index mark )

    echo("<input type=\"hidden\" ");
    echo("name=\""); echo($name); echo("\" ");
    echo("value=\"");
    if ($locidx[0][0] != WED_MAX_INT) {
        echo($yy);
    }
    if (($locidx[0][0] != WED_MAX_INT) && ($locidx[0][1] != WED_MAX_INT)) {
        echo("-");
    }
    if ($locidx[0][1] != WED_MAX_INT) {
        echo($mm);
    }
    if (($locidx[0][1] != WED_MAX_INT) && ($locidx[0][2] != WED_MAX_INT)) {
        echo("-");
    }
    if ($locidx[0][2] != WED_MAX_INT) {
        echo($dd);
    }
    if (($locidx[0][2] != WED_MAX_INT) && ($locidx[0][3] != WED_MAX_INT)) {
        echo(" ");
    }
    if ($locidx[0][3] != WED_MAX_INT) {
        echo($hh);
    }
    if (($locidx[0][3] != WED_MAX_INT) && ($locidx[0][4] != WED_MAX_INT)) {
        echo(":");
    }
    if ($locidx[0][4] != WED_MAX_INT) {
        echo($mi);
    }
    echo("\">");

    for ($i = 0; $i < 5; $i++) {
        if ($locidx[0][$i] != WED_MAX_INT) {
            switch ($locidx[1][$i]) {
                case 1:
                    printf("<select value=\"%d\" onChange=\"wed_check_date(this, this.form.%s, %d, %d, %d, %d, %d)\">\n", $yy, $name, $locidx[2][0], $locidx[2][1], $locidx[2][2], $locidx[2][3], $locidx[2][4]);
                    write_option(1900, 2020, $yy);
                    echo("</select>");
                    break;

                case 2:
                    printf("<select value=\"%d\" onChange=\"wed_check_date(this, this.form.%s, %d, %d, %d, %d, %d)\">\n", $mm, $name, $locidx[2][0], $locidx[2][1], $locidx[2][2], $locidx[2][3], $locidx[2][4]);
                    write_option(1, 12, $mm);
                    echo("</select>");
                    break;

                case 3:
                    printf("<select value=\"%d\" onChange=\"wed_check_date(this, this.form.%s, %d, %d, %d, %d, %d)\">\n", $dd, $name, $locidx[2][0], $locidx[2][1], $locidx[2][2], $locidx[2][3], $locidx[2][4]);
                    if ($mm == 2) {
                        if (($yy % 400 == 0) || (($yy % 4 == 0) && ($yy % 100 != 0))) {
                            write_option(1, 29, $dd);
                        } else {
                            write_option(1, 28, $dd);
                        }
                    } else {
                        if ($mm == 4 || $mm == 6 || $mm == 9 || $mm == 11) {
                            write_option(1, 30, $dd);
                        } else {
                            write_option(1, 31, $dd);
                        }
                    }
                    echo("</select>");
                    break;

                case 4:
                    printf("<select value=\"%d\" onChange=\"wed_check_date(this, this.form.%s, %d, %d, %d, %d, %d)\">\n", $hh, $name, $locidx[2][0], $locidx[2][1], $locidx[2][2], $locidx[2][3], $locidx[2][4]);
                    write_option(0, 23, $hh);
                    echo("</select>");
                    break;

                case 5:
                    printf("<select value=\"%d\" onChange=\"wed_check_date(this, this.form.%s, %d, %d, %d, %d, %d)\">\n", $mi, $name, $locidx[2][0], $locidx[2][1], $locidx[2][2], $locidx[2][3], $locidx[2][4]);
                    write_option(0, 59, $mi);
                    echo("</select>");
                    break;
            }
            echo($fmtstr[$i+1]);
        }
    }
}

//----------------------------------------------------------

function wed_list_move_page($disppages, $disprows, $startrow, $maxrows, $params)
{
	if (strlen($params) > 0) {
		$params = "&" . $params;
	}

    $url = getenv("PATH_INFO");

    $curpage = $startrow / $disprows;
    $maxpages = ceil($maxrows / $disprows);

    if ($maxpages < $disppages) {
        $startpage = 0;
        $endpage   = $maxpages - 1;
    } else {
        $endpage   = $curpage + floor($disppages / 2);
        $startpage = $endpage - $disppages + 1;

        if ($startpage < 0) {
            $endpage   = $endpage - $startpage;
            $startpage = 0;
        }
        if ($maxpages <= $endpage) {
            $startpage = $startpage - ($endpage - $maxpages + 1);
            $endpage   = $maxpages - 1;
        }
    }

    if (0 < $curpage) {
        printf("[<a href=\"%s?startrow=%d&maxrows=%d%s\"><<</a>]\n", $url, ($curpage-1) * $disprows, $maxrows, $params);
    }
    echo("[\n");
    if (0 < $startpage) {
        printf("<a href=\"%s?startrow=%d&maxrows=%d%s\">%d</a> \n", $url, 0, $maxrows, $params, 1);
    }
    if (1 < $startpage) {
        echo("...\n");
    }
    for ($page = $startpage; $page <= $endpage; $page++) {
        if ($page == $curpage) {
            printf("<b>%d</b> \n", $page+1);
        } else {
            printf("<a href=\"%s?startrow=%d&maxrows=%d%s\">%d</a> \n", $url, $page * $disprows, $maxrows, $params, $page+1);
        }
    }
    if ($endpage < ($maxpages-2)) {
        echo("...\n");
    }
    if ($endpage < ($maxpages-1)) {
        printf("<a href=\"%s?startrow=%d&maxrows=%d%s\">%d</a> \n", $url, ($maxpages-1) * $disprows, $maxrows, $params, $maxpages);
    }
    echo("]\n");
    if ($curpage < ($maxpages-1)) {
        printf("[<a href=\"%s?startrow=%d&maxrows=%d%s\">>></a>]\n", $url, ($curpage+1) * $disprows, $maxrows, $params);
    }
}

//----------------------------------------------------------

function wed_db_process($servername, $userid, $passwd, $sqlstr)
{
    $connect = odbc_connect($servername, $userid, $passwd);
    $cursor  = odbc_exec($connect, $sqlstr);

    odbc_close($connect);
}

//----------------------------------------------------------

function wed_read_process($servername, $userid, $passwd, $sqlstr, &$record)
{
    $connect = odbc_connect($servername, $userid, $passwd);
    $cursor  = odbc_exec($connect, $sqlstr);

    for ($rows = 0; odbc_fetch_into($cursor, /*$rows,*/ &$row); $rows++) {
        $record[$rows] = $row;
    }

    odbc_close($connect);
}

//----------------------------------------------------------

function wed_read_list_process($servername, $userid, $passwd, $sqlstr, &$record, $disprows, $startrow, &$maxrows, &$rows)
{
    $connect = odbc_connect($servername, $userid, $passwd);
    $cursor  = odbc_exec($connect, $sqlstr);

    // skip pre list
    for ($i = 0; $i < $startrow; $i++) {
        odbc_fetch_into($cursor, /*$i,*/ &$row);
    }

    // fetch list (max disprows rows)
    for ($rows = 0; ($rows < $disprows) && odbc_fetch_into($cursor, /*$startrow + $rows,*/ &$row); $rows++) {
        $record[$rows] = $row;
    }

    // determine maxrows
    if ($maxrows == 0) {
        for ($maxrows = $startrow + $rows; odbc_fetch_into($cursor, /*$maxrows,*/ &$row); $maxrows++) {
            ;
        }
    }

    odbc_close($connect);
}

//----------------------------------------------------------

function wed_write($value)
{
	if ($value != null) {
    	$length = strlen($value);

    	$pos1 = strpos($value, "#");

        if ($pos1 !== FALSE) {
    		$pos2 = strpos($value, "#", $pos1+1);

        	if ($length == $pos2 + 1) {
        		$link_str = substr($value, $pos1 + 1, $pos2 - $pos1 - 1);
        		if ($pos1 == 0)
        			$text_str = substr($value, $pos1 + 1, $pos2 - $pos1 - 1);
        		else
        			$text_str = substr($value, 0, $pos1);
        		$value = sprintf("<a href=\"%s\">%s</a>", $link_str, $text_str);
        	}
        }

		$w_value = str_replace("\n", "<br>", $value);
	}
	else {
		$w_value = "&nbsp;";
	}
    echo($w_value);
}

//----------------------------------------------------------

function wed_write_link($link, $argname, $argvalue, $value)
{
	if (($argname!=null) && ($argname!="")) {
	    echo("<a href=\""); echo($link);
    	echo("?"); echo($argname); echo("="); echo($argvalue); echo("\">");
	} else {
	    echo("<a href=\""); echo($link);
    	echo("\">");
	}

    echo($value); echo("</a>");
}

//----------------------------------------------------------

function wed_chart_process1($servername, $userid, $passwd, $sqlstr, $legend, $xcol, $value_field, $chart_style, $img_url, $img_option)
{
    $connect = odbc_connect($servername, $userid, $passwd);
    $cursor  = odbc_exec($connect, $sqlstr);

    for ($rows = 0; odbc_fetch_into($cursor, &$row); $rows++) {
        $record[$rows] = $row;
    }
    odbc_close($connect);

    printf("<img src=\"%s?", $img_url);
    $k = 0;
    for ($i = 0; $i < $legend; $i++) {
        echo($i + 1); echo("d=,{");
        for ($j = 0; $j < $xcol; $j++) {
            if ($k < $rows) {
                echo($record[$k][$value_field]);
            }
            echo(",");
            $k++;
        }
        echo("},&");
    }
    printf("%s\" %s>\n", $chart_style, $img_option);
}

//----------------------------------------------------------

function find_str($data, $str)
{
    $items = count($data);

    for ($i = 0; $i < $items; $i++) {
        if (strcmp($data[$i], $str) == 0) {
            return $i;
        }
    }

    return -1;
}

function wed_chart_process2($servername, $userid, $passwd, $sqlstr, $legend_field, $xcol_field, $value_field, $chart_style, $img_url, $img_option)
{
    $connect = odbc_connect($servername, $userid, $passwd);
    $cursor  = odbc_exec($connect, $sqlstr);

    for ($rows = 0; odbc_fetch_into($cursor, &$row); $rows++) {
        $record[$rows] = $row;
    }
    odbc_close($connect);

	$legend_data = array();
	$xcol_data = array();

    for ($i = 0; $i < $rows; $i++) {
        $legend = find_str($legend_data, (string)$record[$i][$legend_field]);
        if ($legend == -1) {
            $legend = count($legend_data);
            $legend_data[$legend] = (string)$record[$i][$legend_field];
        }
        $xcol = find_str($xcol_data, (string)$record[$i][$xcol_field]);
        if ($xcol == -1) {
            $xcol = count($xcol_data);
            $xcol_data[$xcol] = (string)$record[$i][$xcol_field];
        }
    }

	$legend = count($legend_data);
	$xcol   = count($xcol_data);

	for ($i = 0; $i < $legend; $i++) {
		for ($j = 0; $j < $xcol; $j++) {
	    	$value_data[$i][$j] = 0;
	    }
	}

    for ($i = 0; $i < $rows; $i++) {
        $legend = find_str($legend_data, (string)$record[$i][$legend_field]);
        $xcol   = find_str($xcol_data, (string)$record[$i][$xcol_field]);
        $value_data[$legend][$xcol] = (double)$record[$i][$value_field];
    }

    $legend = count($legend_data);
    $xcol   = count($xcol_data);

    printf("<img src=\"%s?xd=", $img_url);
    for ($i = 0; $i < $xcol; $i++) {
        printf("%s,", $xcol_data[$i]);
    }
    echo("&");
    for ($i = 0; $i < $legend; $i++) {
        printf("%dd=%s,{", $i + 1, $legend_data[$i]);
        for ($j = 0; $j < $xcol; $j++) {
            if ($value_data[$i][$j] != 0) printf("%f,", $value_data[$i][$j]);
            else						  printf(",", $value_data[$i][$j]);
        }
        echo("},&");
    }
    printf("%s\" %s>\n", $chart_style, $img_option);
}

//----------------------------------------------------------

?>

<SCRIPT LANGUAGE="JavaScript">
<!--
function wed_check_int(e)
{
}

function wed_check_date(e, h, yy_idx, mm_idx, dd_idx, hh_idx, mi_idx)
{
    var base_idx, yy, mm, dd, hh, mi, i, days, new_option

    for (base_idx = 0; base_idx < e.form.length; base_idx++)
        if (e.form.elements[base_idx] == h) break
    if (e.form.length <= base_idx) return 0

    if (yy_idx != -1) yy = e.form.elements[base_idx + yy_idx].options[e.form.elements[base_idx + yy_idx].selectedIndex].value
    if (mm_idx != -1) mm = e.form.elements[base_idx + mm_idx].options[e.form.elements[base_idx + mm_idx].selectedIndex].value
    if (dd_idx != -1) dd = e.form.elements[base_idx + dd_idx].options[e.form.elements[base_idx + dd_idx].selectedIndex].value
    if (hh_idx != -1) hh = e.form.elements[base_idx + hh_idx].options[e.form.elements[base_idx + hh_idx].selectedIndex].value
    if (mi_idx != -1) mi = e.form.elements[base_idx + mi_idx].options[e.form.elements[base_idx + mi_idx].selectedIndex].value

    if (dd_idx != -1 && mm_idx != -1 && yy_idx != -1) {
        if (mm == 2) {
            if ((yy % 400 == 0) || ((yy % 4 == 0) && (yy % 100 != 0))) {
                days = 29
            } else {
                days = 28
            }
        } else {
            if (mm == 4 || mm == 6 || mm == 9 || mm == 11) {
                days = 30
            } else {
                days = 31
            }
        }
        if (days != e.form.elements[base_idx + dd_idx].length) {
            e.form.elements[base_idx + dd_idx].length = 0
            for (i = 0; i < days; i++) {
                new_option = new Option(i + 1, i + 1)
                e.form.elements[base_idx + dd_idx].options[i] = new_option
            }
            e.form.elements[base_idx + dd_idx].selectedIndex = dd - 1
        }
    }

    h.value = ''

    if (yy_idx != -1) h.value = yy
    if (mm_idx != -1) h.value = h.value + '-' + mm
    if (dd_idx != -1) h.value = h.value + '-' + dd
    if (hh_idx != -1) h.value = h.value + ' ' + hh
    if (mi_idx != -1) h.value = h.value + ':' + mi

    return 1
}

//-->
</SCRIPT>
